require "TimedActions/ISBaseTimedAction"
local TABAS_Utils = require "TABAS_Utils"

TABAS_WalkInTheTubAction = ISBaseTimedAction:derive("TABAS_WalkInTheTubAction")

function TABAS_WalkInTheTubAction:isValid()
    return true
end

local function switchSolidTrans(object, unset)
    if not object:getSprite() then return end
    local prop = object:getSprite():getProperties()
    if unset and prop:Is(IsoFlagType.solidtrans) then
        prop:UnSet(IsoFlagType.solidtrans)
    else
        prop:Set(IsoFlagType.solidtrans)
    end
    object:getSquare():RecalcPropertiesIfNeeded()
end

function TABAS_WalkInTheTubAction:getFacingDirection()
    local square = self.character:getCurrentSquare()
    if (square:getX() - self.targetSqr:getX()) <= -1 then
        return IsoDirections.E
    elseif (square:getX() - self.targetSqr:getX()) >= 1 then
        return IsoDirections.W
    elseif (square:getY() - self.targetSqr:getY()) <= -1 then
        return IsoDirections.S
    else
        return IsoDirections.N
    end
end

function TABAS_WalkInTheTubAction:waitToStart()
    local currentSquare = self.character:getCurrentSquare()
    if currentSquare:getX() == self.targetSqr:getX() and currentSquare:getY() == self.targetSqr:getY() then
        return false
    end
    local dir = self:getFacingDirection()
    self.character:faceDirection(dir)
    return self.character:shouldBeTurning()
end

function TABAS_WalkInTheTubAction:update()
    if self.direction == IsoDirections.S then
        local diff = self.character:getY() - (self.targetSqr:getY()+0.5)
        if diff >= -0.15 then
            self:forceComplete()
        end
    elseif self.direction == IsoDirections.E then
        local diff = self.character:getX() - (self.targetSqr:getX()+0.5)
        if diff >= -0.15 then
            self:forceComplete()
        end
    elseif self.direction == IsoDirections.N then
        local diff = self.character:getY() - (self.targetSqr:getY()+0.5)
        if diff <= 0.15 then
            self:forceComplete()
        end
    else
        local diff = self.character:getX() - (self.targetSqr:getX()+0.5)
        -- print("Diff = " .. tostring(diff))
        if diff <= 0.15 then
            self:forceComplete()
        end
    end
    if not self.sound and self.tfc_Base then
        local ratio = self.tfc_Base:getRatio()
        if ratio > self.tfc_Base.filledConst.HalfLow then
            self.sound = self.character:getEmitter():playSound("tabas_bath_wave01")
        elseif ratio > self.tfc_Base.filledConst.Low then
            self.sound = self.character:getEmitter():playSound("tabas_walkintub01")
        else
            self.sound = true
        end
    end
end

function TABAS_WalkInTheTubAction:start()
    TABAS_Utils.switchObjectSolidtrans(self.object_1, true)
    TABAS_Utils.switchObjectSolidtrans(self.object_2, true)
    self.direction = self:getFacingDirection()
    self:setActionAnim("WalkInTheTub")
end

function TABAS_WalkInTheTubAction:stop()
    TABAS_Utils.switchObjectSolidtrans(self.object_1)
    TABAS_Utils.switchObjectSolidtrans(self.object_2)
    switchSolidTrans(self.object_1)
    switchSolidTrans(self.object_2)
    ISBaseTimedAction.stop(self)
end

function TABAS_WalkInTheTubAction:perform()
    TABAS_Utils.switchObjectSolidtrans(self.object_1)
    TABAS_Utils.switchObjectSolidtrans(self.object_2)
    ISBaseTimedAction.perform(self)
end

function TABAS_WalkInTheTubAction:new(character, object_1, targetSqr, object_2)
    local o = ISBaseTimedAction.new(self, character)
    o.character = character
    o.targetSqr = targetSqr
    o.object_1 = object_1
    o.object_2 = object_2 or TABAS_Utils.getGridExtensionBath(object_1)
    o.tfc_Base = TABAS_Utils.getTfcBaseOnBathObject(object_1)

    o.maxTime = 200
    o.useProgressBar = false
    o.ignoreHandsWounds = true
    return o
end
